/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.theme.extensions;

import com.aptana.theme.ConsoleThemer;
import com.aptana.theme.internal.TextViewerThemer;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsolePageParticipant;
import org.eclipse.ui.console.IOConsoleOutputStream;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.console.TextConsolePage;
import org.eclipse.ui.part.IPageBookViewPage;

public class ConsoleThemePageParticipant
implements IConsolePageParticipant {
    public static final String THEME_CONSOLE_STREAM_TO_COLOR_ATTRIBUTE = "themeConsoleStreamToColor";
    private ConsoleThemer extension;
    private TextViewerThemer themer;

    public void init(IPageBookViewPage page, IConsole console) {
        if (console instanceof TextConsole) {
            TextConsole textConsole = (TextConsole)console;
            Object themeConsoleStreamToColor = textConsole.getAttribute(THEME_CONSOLE_STREAM_TO_COLOR_ATTRIBUTE);
            if (themeConsoleStreamToColor instanceof Map) {
                Map m = (Map)themeConsoleStreamToColor;
                Set entrySet = m.entrySet();
                for (Map.Entry entry : entrySet) {
                    if (entry.getKey() instanceof IOConsoleOutputStream && entry.getValue() instanceof String) continue;
                    return;
                }
                this.extension = new ConsoleThemer(textConsole, (Map)themeConsoleStreamToColor);
            }
            if (page instanceof TextConsolePage) {
                TextConsolePage tcp = (TextConsolePage)page;
                this.themer = new TextViewerThemer((ITextViewer)tcp.getViewer());
                this.themer.apply();
            }
        }
    }

    public void activated() {
        this.themer.apply();
    }

    public void deactivated() {
    }

    public void dispose() {
        if (this.extension != null) {
            this.extension.dispose();
            this.extension = null;
        }
    }

    public Object getAdapter(Class adapter) {
        return null;
    }
}

